/*
 * Decompiled with CFR 0.152.
 */
package com.smfreports.dataset;

import com.blackhillsoftware.smf.SmfRecord;
import com.blackhillsoftware.smf.smf14.Smf14Record;
import com.blackhillsoftware.smf.smf17.Smf17Record;
import com.blackhillsoftware.smf.smf18.Smf18Record;
import com.blackhillsoftware.smf.smf61.Smf61Record;
import com.blackhillsoftware.smf.smf62.Smf62Record;
import com.blackhillsoftware.smf.smf64.Smf64Record;
import com.blackhillsoftware.smf.smf65.Smf65Record;
import java.time.LocalDateTime;

public class DatasetActivityEvent {
    private LocalDateTime time;
    private String datasetname;
    private String jobname;
    private String userid;
    private String event;
    private String newname;
    private boolean readEvent = false;

    private DatasetActivityEvent() {
    }

    public static DatasetActivityEvent from(SmfRecord record) {
        switch (record.recordType()) {
            case 14: 
            case 15: {
                return DatasetActivityEvent.from(Smf14Record.from((SmfRecord)record));
            }
            case 17: {
                return DatasetActivityEvent.from(Smf17Record.from((SmfRecord)record));
            }
            case 18: {
                return DatasetActivityEvent.from(Smf18Record.from((SmfRecord)record));
            }
            case 61: {
                return DatasetActivityEvent.from(Smf61Record.from((SmfRecord)record));
            }
            case 62: {
                return DatasetActivityEvent.from(Smf62Record.from((SmfRecord)record));
            }
            case 64: {
                return DatasetActivityEvent.from(Smf64Record.from((SmfRecord)record));
            }
            case 65: {
                return DatasetActivityEvent.from(Smf65Record.from((SmfRecord)record));
            }
        }
        throw new IllegalArgumentException("Unexpected record type: " + record.recordType());
    }

    private static DatasetActivityEvent from(Smf14Record r14) {
        DatasetActivityEvent datasetevent = new DatasetActivityEvent();
        datasetevent.datasetname = r14.smfjfcb1().jfcbdsnm();
        datasetevent.jobname = r14.smf14jbn();
        datasetevent.userid = r14.smf14uid();
        datasetevent.time = r14.smfDateTime();
        if (r14.recordType() == 15) {
            datasetevent.event = "Update (15)";
        } else {
            datasetevent.event = "Read (14)";
            datasetevent.readEvent = true;
        }
        return datasetevent;
    }

    private static DatasetActivityEvent from(Smf17Record r17) {
        DatasetActivityEvent datasetevent = new DatasetActivityEvent();
        datasetevent.datasetname = r17.smf17dsn();
        datasetevent.jobname = r17.smf17jbn();
        datasetevent.userid = r17.smf17uid();
        datasetevent.time = r17.smfDateTime();
        datasetevent.event = "Delete (17)";
        return datasetevent;
    }

    private static DatasetActivityEvent from(Smf18Record r18) {
        DatasetActivityEvent datasetevent = new DatasetActivityEvent();
        datasetevent.datasetname = r18.smf18ods();
        datasetevent.jobname = r18.smf18jbn();
        datasetevent.userid = r18.smf18uid();
        datasetevent.time = r18.smfDateTime();
        datasetevent.event = "Rename (18)";
        datasetevent.newname = r18.smf18nds();
        return datasetevent;
    }

    private static DatasetActivityEvent from(Smf61Record r61) {
        DatasetActivityEvent datasetevent = new DatasetActivityEvent();
        datasetevent.datasetname = r61.smf61enm();
        datasetevent.jobname = r61.smf61jnm();
        datasetevent.userid = r61.smf61uid();
        datasetevent.time = r61.smfDateTime();
        datasetevent.event = "Create (61)";
        return datasetevent;
    }

    private static DatasetActivityEvent from(Smf62Record r62) {
        DatasetActivityEvent datasetevent = new DatasetActivityEvent();
        datasetevent.datasetname = r62.smf62dnm();
        datasetevent.jobname = r62.smf62jbn();
        datasetevent.userid = r62.smf62uif();
        datasetevent.time = r62.smfDateTime();
        if ((r62.statisticsSection().smf62mc1() & 2) != 0) {
            datasetevent.event = "Update (62)";
        } else {
            datasetevent.event = "Read (62)";
            datasetevent.readEvent = true;
        }
        return datasetevent;
    }

    private static DatasetActivityEvent from(Smf64Record r64) {
        DatasetActivityEvent datasetevent = new DatasetActivityEvent();
        datasetevent.datasetname = r64.smf64dnm();
        datasetevent.jobname = r64.smf64jbn();
        datasetevent.userid = r64.smf64uif();
        datasetevent.time = r64.smfDateTime();
        if ((r64.statisticsSection().smf64mc1() & 2) != 0) {
            datasetevent.event = "Update (64)";
        } else {
            datasetevent.event = "Read (64)";
            datasetevent.readEvent = true;
        }
        return datasetevent;
    }

    private static DatasetActivityEvent from(Smf65Record r65) {
        DatasetActivityEvent datasetevent = new DatasetActivityEvent();
        datasetevent.datasetname = r65.smf65enm();
        datasetevent.jobname = r65.smf65jnm();
        datasetevent.userid = r65.smf65uid();
        datasetevent.time = r65.smfDateTime();
        datasetevent.event = "Delete (65)";
        return datasetevent;
    }

    public String getDatasetname() {
        return this.datasetname;
    }

    public String getNewname() {
        return this.newname != null ? this.newname : "";
    }

    public String getJobname() {
        return this.jobname;
    }

    public String getUserid() {
        return this.userid;
    }

    public LocalDateTime getTime() {
        return this.time;
    }

    public String getEvent() {
        return this.event;
    }

    public boolean isRead() {
        return this.readEvent;
    }
}

