/*
 * Decompiled with CFR 0.152.
 */
package com.smfreports.rmf;

import com.blackhillsoftware.smf.Importance;
import com.blackhillsoftware.smf.SmfRecord;
import com.blackhillsoftware.smf.SmfRecordReader;
import com.blackhillsoftware.smf.smf72.Smf72Record;
import com.blackhillsoftware.smf.smf72.subtype3.ServiceReportClassPeriodDataSection;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public class PerformanceIndex {
    public static void main(String[] args) throws IOException {
        if (args.length < 1) {
            System.out.println("Usage: PerformanceIndex <input-name>");
            System.out.println("<input-name> can be filename, //DD:DDNAME or //'DATASET.NAME'");
            return;
        }
        ArrayList<ServiceClassPeriod> highPI = new ArrayList<ServiceClassPeriod>();
        try (SmfRecordReader reader = SmfRecordReader.fromName((String)args[0]);){
            for (SmfRecord record : reader) {
                Smf72Record r72;
                if (record.recordType() != 72 || record.subType() != 3 || (r72 = Smf72Record.from((SmfRecord)record)).workloadManagerControlSection().r723mrcl()) continue;
                for (ServiceReportClassPeriodDataSection section : r72.serviceReportClassPeriodDataSections()) {
                    if (!(section.performanceIndex() > 2.0) || section.r723cvel() && section.r723ctot() + section.r723ctou() <= r72.workloadManagerControlSection().r723mtvNum() / 20L) continue;
                    highPI.add(new ServiceClassPeriod(r72, section));
                }
            }
        }
        PerformanceIndex.writeReport(highPI);
    }

    private static void writeReport(ArrayList<ServiceClassPeriod> highPI) {
        Collections.sort(highPI, new ServiceClassPeriodComparator());
        DateTimeFormatter timef = DateTimeFormatter.ISO_LOCAL_TIME;
        DateTimeFormatter datef = DateTimeFormatter.ISO_LOCAL_DATE;
        LocalDateTime currentTime = null;
        String currentSystem = null;
        Importance currentImportance = null;
        for (ServiceClassPeriod scInfo : highPI) {
            if (!scInfo.system.equals(currentSystem)) {
                System.out.format("%n%s%n", scInfo.system);
                currentSystem = scInfo.system;
                currentTime = null;
                currentImportance = null;
            }
            if (!scInfo.time.equals(currentTime)) {
                System.out.format("%n   %s %s%n", scInfo.time.format(datef), scInfo.time.format(timef));
                currentTime = scInfo.time;
                currentImportance = null;
            }
            if (scInfo.importance != currentImportance) {
                System.out.format("      Importance: %s%n", scInfo.importance);
                currentImportance = scInfo.importance;
            }
            System.out.format("         %-8s Period %s %3.1f%n", scInfo.name, scInfo.period, scInfo.perfIndex);
        }
    }

    private static class ServiceClassPeriod {
        String system;
        LocalDateTime time;
        String name;
        int period;
        Importance importance;
        double perfIndex;

        public ServiceClassPeriod(Smf72Record record, ServiceReportClassPeriodDataSection section) {
            this.system = record.system();
            this.time = record.smfDateTime().plusSeconds(30L).truncatedTo(ChronoUnit.MINUTES);
            this.name = record.workloadManagerControlSection().r723mcnm();
            this.period = section.r723cper();
            this.importance = section.importance();
            this.perfIndex = section.performanceIndex();
        }
    }

    private static class ServiceClassPeriodComparator
    implements Comparator<ServiceClassPeriod> {
        private ServiceClassPeriodComparator() {
        }

        @Override
        public int compare(ServiceClassPeriod s1, ServiceClassPeriod s2) {
            int result = s1.system.compareTo(s2.system);
            if (result != 0) {
                return result;
            }
            result = s1.time.compareTo(s2.time);
            if (result != 0) {
                return result;
            }
            result = s2.importance.compareTo((Enum)s1.importance);
            if (result != 0) {
                return result;
            }
            result = Double.compare(s2.perfIndex, s1.perfIndex);
            if (result != 0) {
                return result;
            }
            result = s1.name.compareTo(s2.name);
            if (result != 0) {
                return result;
            }
            result = Integer.compare(s1.period, s2.period);
            return result;
        }
    }
}

