/*
 * Decompiled with CFR 0.152.
 */
package com.smfreports.rmf;

import com.blackhillsoftware.smf.SmfRecord;
import com.blackhillsoftware.smf.SmfRecordReader;
import com.blackhillsoftware.smf.smf70.Smf70Record;
import com.blackhillsoftware.smf.smf70.subtype1.CpuIdentificationSection;
import com.blackhillsoftware.smf.smf70.subtype1.PrismLogicalProcessorDataSection;
import com.blackhillsoftware.smf.smf70.subtype1.PrismPartitionDataSection;
import java.io.IOException;
import java.time.DayOfWeek;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.chrono.ChronoLocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PrimeShiftDailyCpu {
    public static void main(String[] args) throws IOException {
        if (args.length < 1) {
            System.out.println("Usage: PrimeShiftDailyCpu <input-name>");
            System.out.println("<input-name> can be filename, //DD:DDNAME or //'DATASET.NAME'");
            return;
        }
        LocalTime primestart = LocalTime.of(8, 30);
        LocalTime primeend = LocalTime.of(17, 30);
        List<DayOfWeek> primedays = Arrays.asList(DayOfWeek.MONDAY, DayOfWeek.TUESDAY, DayOfWeek.WEDNESDAY, DayOfWeek.THURSDAY, DayOfWeek.FRIDAY);
        List<String> datasystems = Arrays.asList("SYSA", "SYSB");
        HashMap<LocalDate, Map<String, Map<String, List<Duration>>>> dailyCpuStatistics = new HashMap<LocalDate, Map<String, Map<String, List<Duration>>>>();
        try (SmfRecordReader reader = SmfRecordReader.fromName((String)args[0]);){
            reader.include(70, 1).stream().filter(record -> datasystems.contains(record.system()) && primedays.contains(record.smfDate().getDayOfWeek()) && record.smfTime().isAfter(primestart) && record.smfTime().isBefore(primeend)).map(record -> Smf70Record.from((SmfRecord)record)).forEach(r70 -> {
                List lpSections = r70.prismLogicalProcessorDataSections();
                List cpuIdSections = r70.cpuIdentificationSections();
                for (PrismPartitionDataSection partition : r70.prismPartitionDataSections()) {
                    int partitionLogicalProcessors = partition.smf70bdn();
                    int skipSections = (int)partition.smf70bds();
                    for (int i = 0; i < partitionLogicalProcessors; ++i) {
                        PrismLogicalProcessorDataSection lpSection = (PrismLogicalProcessorDataSection)lpSections.get(skipSections + i);
                        String cputype = ((CpuIdentificationSection)cpuIdSections.get(lpSection.smf70cix() - 1)).smf70cin();
                        dailyCpuStatistics.computeIfAbsent(r70.smfDate(), day -> new HashMap()).computeIfAbsent(partition.smf70lpm(), system -> new HashMap()).computeIfAbsent(cputype, cpu -> new ArrayList()).add(lpSection.smf70pdt());
                    }
                }
            });
        }
        PrimeShiftDailyCpu.writeReport(dailyCpuStatistics);
        System.out.println("Done");
    }

    private static void writeReport(Map<LocalDate, Map<String, Map<String, List<Duration>>>> dailyCpuStatistics) {
        dailyCpuStatistics.entrySet().stream().sorted((a, b) -> ((LocalDate)a.getKey()).compareTo((ChronoLocalDate)b.getKey())).forEachOrdered(day -> {
            System.out.format("%n%s %s%n", day.getKey(), ((LocalDate)day.getKey()).getDayOfWeek());
            ((Map)day.getValue()).entrySet().stream().sorted((a, b) -> ((String)a.getKey()).compareTo((String)b.getKey())).forEachOrdered(lpar -> {
                System.out.format("%n    %-8s %12s%n", lpar.getKey(), "HHH:MM:SS");
                ((Map)lpar.getValue()).entrySet().stream().sorted((a, b) -> ((String)a.getKey()).compareTo((String)b.getKey())).forEachOrdered(cpuType -> {
                    Duration total = ((List)cpuType.getValue()).stream().reduce(Duration.ZERO, (a, b) -> a.plus((Duration)b));
                    System.out.format("        %-4s %12s%n", cpuType.getKey(), PrimeShiftDailyCpu.hhhmmss(total));
                });
            });
        });
    }

    private static String hhhmmss(Duration dur) {
        long hours = dur.toHours();
        long minutes = dur.minus(Duration.ofHours(hours)).toMinutes();
        long seconds = dur.minus(Duration.ofHours(hours)).minus(Duration.ofMinutes(minutes)).toMillis() / 1000L;
        return String.format("%d:%02d:%02d", hours, minutes, seconds);
    }
}

