/*
 * Decompiled with CFR 0.152.
 */
package com.smfreports.tcpip;

import com.blackhillsoftware.smf.SmfRecord;
import com.blackhillsoftware.smf.SmfRecordReader;
import com.blackhillsoftware.smf.smf119.Smf119Record;
import com.blackhillsoftware.smf.smf119.zert.TLSHandshakeRole;
import java.io.IOException;
import java.util.Comparator;
import java.util.Map;
import java.util.function.BinaryOperator;
import java.util.stream.Collectors;

public class ZertCertificatesByJobname {
    public static void main(String[] args) throws IOException, IllegalArgumentException {
        if (args.length < 1) {
            System.out.println("Usage: ZertCertificatesByJobname <input-name>");
            System.out.println("<input-name> can be filename, //DD:DDNAME or //'DATASET.NAME'");
            return;
        }
        try (SmfRecordReader reader = SmfRecordReader.fromName((String)args[0]).include(119, 11);){
            Map<String, Map<GroupKey, Smf119Record>> result = reader.stream().map(record -> Smf119Record.from((SmfRecord)record)).filter(r119 -> r119.zertDetailCommonSection().smf119scSaSecProtoTls()).filter(r119 -> r119.zertDetailTLSSection() != null).filter(r119 -> r119.zertDetailTLSSection().smf119scTlsHandshakeRole() == TLSHandshakeRole.SERVER || r119.zertDetailTLSSection().smf119scTlsHandshakeRole() == TLSHandshakeRole.SRV_CA).collect(Collectors.groupingBy(r119 -> r119.zertDetailTLSSection().smf119scTlsSCertSerial() != null ? r119.zertDetailTLSSection().smf119scTlsSCertSerial().asHex() : "N/A", Collectors.toMap(GroupKey::new, r119 -> r119, BinaryOperator.maxBy(Comparator.comparing(x -> x.zertDetailCommonSection().smf119scSaSDateTime())))));
            ZertCertificatesByJobname.writeReport(result);
        }
        System.out.println("Finished");
    }

    private static void writeReport(Map<String, Map<GroupKey, Smf119Record>> result) {
        System.out.format("%-40s %-23s %-8s %-8s %-25s %-8s %-8s %-24s%n", "Certificate Serial", "Certificate Expiry", "Jobname", "System", "Latest", "Jobid", "Userid", "Provider");
        result.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEachOrdered(certEntry -> {
            Map jobRecords = (Map)certEntry.getValue();
            Smf119Record first = (Smf119Record)jobRecords.values().iterator().next();
            if (first.zertDetailTLSSection().smf119scTlsSCertSerial() != null) {
                System.out.format("%n%-40s %s%n", certEntry.getKey(), first.zertDetailTLSSection().smf119scTlsSCertTime());
                first.zertDetailCertificateDN().forEach(dn -> System.out.println(" ".repeat(4) + dn.smf119scDn()));
            } else {
                System.out.println();
                System.out.println("N/A");
            }
            jobRecords.entrySet().stream().sorted(Comparator.comparing(entry -> ((GroupKey)entry.getKey()).jobname).thenComparing(entry -> ((GroupKey)entry.getKey()).system)).forEachOrdered(entry -> {
                GroupKey key = (GroupKey)entry.getKey();
                Smf119Record r119 = (Smf119Record)entry.getValue();
                System.out.print(" ".repeat(65));
                System.out.format("%-8s %-8s %-25s %-8s %-8s %-15s%n", key.jobname, key.system, r119.zertDetailCommonSection().smf119scSaSDateTime(), r119.zertDetailCommonSection().smf119scSaJobID(), r119.zertDetailCommonSection().smf119scSaUserID(), r119.zertDetailTLSSection().smf119scTlsProtocolProvider());
            });
        });
    }

    record GroupKey(String system, String jobname) {
        public GroupKey(Smf119Record r119) {
            this(r119.system(), r119.zertDetailCommonSection().smf119scSaJobname());
        }
    }
}

