/*
 * Decompiled with CFR 0.152.
 */
package com.smfreports.type30;

import com.blackhillsoftware.smf.SmfRecord;
import com.blackhillsoftware.smf.SmfRecordReader;
import com.blackhillsoftware.smf.smf30.Smf30Record;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class BeforeAfterProgramStatistics {
    private static void printUsage() {
        System.out.println("Usage: BeforeAfterProgramStatistics <date-time> <input-file>");
        System.out.println("");
        System.out.println("  date-time    The local date-time to be used for the before/after split.");
        System.out.println("               This is parsed by java.time.LocalDateTime.parse() using");
        System.out.println("               DateTimeFormatter.ISO_LOCAL_DATE_TIME format");
        System.out.println("               e.g. 2020-01-31T12:30:00");
        System.out.println("");
        System.out.println("  input-file   File containing SMF records. Binary data, RECFM=U or V[B]");
        System.out.println("               including RDW.");
        System.out.println("");
    }

    public static void main(String[] args) throws IOException {
        if (args.length != 2 || args[0].equals("--help") || args[0].equals("-h")) {
            BeforeAfterProgramStatistics.printUsage();
            System.exit(0);
        }
        try {
            LocalDateTime boundary = LocalDateTime.parse(args[0]);
            HashMap<String, ProgramStatistics> beforePrograms = new HashMap<String, ProgramStatistics>();
            HashMap<String, ProgramStatistics> afterPrograms = new HashMap<String, ProgramStatistics>();
            try (SmfRecordReader reader = SmfRecordReader.fromName((String)args[1]);){
                reader.include(30, 4);
                for (SmfRecord record : reader) {
                    Smf30Record r30 = Smf30Record.from((SmfRecord)record);
                    String programName = r30.identificationSection().smf30pgm();
                    HashMap<String, ProgramStatistics> target = r30.smfDateTime().isBefore(boundary) ? beforePrograms : afterPrograms;
                    target.computeIfAbsent(programName, key -> new ProgramStatistics(programName)).accumulateData(r30);
                }
            }
            BeforeAfterProgramStatistics.writeReport(beforePrograms, afterPrograms);
        }
        catch (Exception e) {
            BeforeAfterProgramStatistics.printUsage();
            throw e;
        }
    }

    private static void writeReport(Map<String, ProgramStatistics> beforePrograms, Map<String, ProgramStatistics> afterPrograms) {
        String headerFormatString = "%n%-8s %8s %14s %14s %14s %14s %14s %14s %14s%n";
        String detailFormatString = "%-8s %,8d %14s %14s %14s %,14d %13.1f%% %13.1f%% %14s%n";
        String changeFormatString = "%-77s %14s %14s %14s%n%n";
        System.out.format(headerFormatString, "Program", "Count", "CP", "zIIP", "zIIP on CP", "EXCP", "zIIP%", "zIIP on CP%", "CPU ms/IO");
        beforePrograms.values().stream().filter(beforeProgramsEntry -> afterPrograms.containsKey(beforeProgramsEntry.getName())).sorted(Comparator.comparing(ProgramStatistics::getCpTime).reversed()).limit(100L).forEachOrdered(beforeInfo -> {
            ProgramStatistics afterInfo = (ProgramStatistics)afterPrograms.get(beforeInfo.getName());
            System.out.format("%-8s%n", beforeInfo.getName());
            System.out.format(detailFormatString, "Before:", beforeInfo.getCount(), BeforeAfterProgramStatistics.hhhmmss(beforeInfo.getCpTime()), BeforeAfterProgramStatistics.hhhmmss(beforeInfo.getZiipTime()), BeforeAfterProgramStatistics.hhhmmss(beforeInfo.getZiipOnCpTime()), beforeInfo.getExcps(), beforeInfo.getZiipPct(), beforeInfo.getZiipOnCpPct(), beforeInfo.getCpuMsPerIO().map(value -> String.format("%.3f", value)).orElse(""));
            System.out.format(detailFormatString, "After:", afterInfo.getCount(), BeforeAfterProgramStatistics.hhhmmss(afterInfo.getCpTime()), BeforeAfterProgramStatistics.hhhmmss(afterInfo.getZiipTime()), BeforeAfterProgramStatistics.hhhmmss(afterInfo.getZiipOnCpTime()), afterInfo.getExcps(), afterInfo.getZiipPct(), afterInfo.getZiipOnCpPct(), afterInfo.getCpuMsPerIO().map(value -> String.format("%.3f", value)).orElse(""));
            System.out.format(changeFormatString, "Change:", afterInfo.getZiipPctChange((ProgramStatistics)beforeInfo).map(value -> String.format("%+.1f%%", value)).orElse(""), afterInfo.getZiipOnCpPctChange((ProgramStatistics)beforeInfo).map(value -> String.format("%+.1f%%", value)).orElse(""), afterInfo.getCpuMsPerIOChange((ProgramStatistics)beforeInfo).map(value -> String.format("%+.0f%%", value)).orElse(""));
        });
    }

    private static String hhhmmss(double totalseconds) {
        int SECONDS_PER_MINUTE = 60;
        int SECONDS_PER_HOUR = 3600;
        int hours = (int)(totalseconds / 3600.0);
        int minutes = (int)(totalseconds % 3600.0) / 60;
        double seconds = totalseconds % 60.0;
        return String.format("%d:%02d:%05.2f", hours, minutes, seconds);
    }

    private static class ProgramStatistics {
        String name;
        int count = 0;
        double cpTime = 0.0;
        double ziipOnCpTime = 0.0;
        double ziipTime = 0.0;
        double normalizedZiipTime = 0.0;
        long excps = 0L;

        public ProgramStatistics(String name) {
            this.name = name;
        }

        public void accumulateData(Smf30Record r30) {
            if (r30.processorAccountingSection() != null) {
                ++this.count;
                this.cpTime += r30.processorAccountingSection().smf30cptSeconds() + r30.processorAccountingSection().smf30cpsSeconds();
                this.ziipTime += r30.processorAccountingSection().smf30TimeOnZiipSeconds();
                this.ziipOnCpTime += r30.processorAccountingSection().smf30TimeZiipOnCpSeconds();
                this.normalizedZiipTime += r30.processorAccountingSection().smf30TimeOnZiipSeconds() * (double)r30.performanceSection().smf30snf() / 256.0;
            }
            if (r30.ioActivitySection() != null) {
                this.excps += r30.ioActivitySection().smf30tex();
            }
        }

        String getName() {
            return this.name;
        }

        int getCount() {
            return this.count;
        }

        double getCpTime() {
            return this.cpTime;
        }

        double getZiipOnCpTime() {
            return this.ziipOnCpTime;
        }

        double getZiipTime() {
            return this.ziipTime;
        }

        double getNormalizedZiipTime() {
            return this.normalizedZiipTime;
        }

        long getExcps() {
            return this.excps;
        }

        Optional<Double> getCpuMsPerIO() {
            return this.excps > 0L ? Optional.of((this.cpTime + this.normalizedZiipTime) * 1000.0 / (double)this.excps) : Optional.empty();
        }

        Optional<Double> getCpuMsPerIOChange(ProgramStatistics prev) {
            Optional<Double> oldvalue = prev.getCpuMsPerIO();
            Optional<Double> newvalue = this.getCpuMsPerIO();
            return oldvalue.isPresent() && newvalue.isPresent() && oldvalue.get() > 0.0 && newvalue.get() > 0.0 ? Optional.of((newvalue.get() / oldvalue.get() - 1.0) * 100.0) : Optional.empty();
        }

        double getZiipPct() {
            return this.cpTime + this.normalizedZiipTime > 0.0 ? this.normalizedZiipTime / (this.cpTime + this.normalizedZiipTime) * 100.0 : 0.0;
        }

        Optional<Double> getZiipPctChange(ProgramStatistics prev) {
            return this.getZiipPct() > 0.0 || prev.getZiipPct() > 0.0 ? Optional.of(this.getZiipPct() - prev.getZiipPct()) : Optional.empty();
        }

        double getZiipOnCpPct() {
            return this.cpTime + this.normalizedZiipTime > 0.0 ? this.ziipOnCpTime / (this.cpTime + this.normalizedZiipTime) * 100.0 : 0.0;
        }

        Optional<Double> getZiipOnCpPctChange(ProgramStatistics prev) {
            return this.getZiipOnCpPct() > 0.0 || prev.getZiipOnCpPct() > 0.0 ? Optional.of(this.getZiipOnCpPct() - prev.getZiipOnCpPct()) : Optional.empty();
        }
    }
}

