/*
 * Decompiled with CFR 0.152.
 */
package com.smfreports.type30;

import com.blackhillsoftware.smf.SmfRecord;
import com.blackhillsoftware.smf.SmfRecordReader;
import com.blackhillsoftware.smf.Token;
import com.blackhillsoftware.smf.smf30.Smf30Record;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class JobsByJclId {
    public static void main(String[] args) throws IOException {
        if (args.length < 1) {
            System.out.println("Usage: JobsByJclId <input-name>");
            System.out.println("<input-name> can be filename, //DD:DDNAME or //'DATASET.NAME'");
            return;
        }
        HashMap<Token, Set> jobsByJclId = new HashMap<Token, Set>();
        try (SmfRecordReader reader = SmfRecordReader.fromName((String)args[0]).include(30, 5);){
            for (SmfRecord record : reader) {
                Smf30Record r30 = Smf30Record.from((SmfRecord)record);
                if (r30.header().smf30wid().equals("TSO") || r30.identificationSection().length() <= 250 || r30.identificationSection().smf30Jclid1().isZeros()) continue;
                jobsByJclId.computeIfAbsent(r30.identificationSection().smf30Jclid1(), entry -> new HashSet()).add(r30.identificationSection().smf30jbn());
            }
        }
        jobsByJclId.entrySet().stream().filter(entry -> ((Set)entry.getValue()).size() > 1).forEach(entry -> {
            System.out.format("%n%s%n", entry.getKey());
            ((Set)entry.getValue()).stream().sorted().forEachOrdered(jobname -> System.out.format("   %s%n", jobname));
        });
        System.out.println("Done");
    }
}

