/*
 * Decompiled with CFR 0.152.
 */
package com.smfreports.type30;

import com.blackhillsoftware.smf.SmfRecord;
import com.blackhillsoftware.smf.SmfRecordReader;
import com.blackhillsoftware.smf.Token;
import com.blackhillsoftware.smf.smf30.Smf30Record;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class JobsByJclIdDetail {
    public static void main(String[] args) throws IOException {
        if (args.length < 1) {
            System.out.println("Usage: JobsByJclIdDetail <input-name>");
            System.out.println("<input-name> can be filename, //DD:DDNAME or //'DATASET.NAME'");
            return;
        }
        HashMap<Token, List> jobsByJclId = new HashMap<Token, List>();
        try (SmfRecordReader reader = SmfRecordReader.fromName((String)args[0]).include(30, 5);){
            for (SmfRecord record : reader) {
                Smf30Record r30 = Smf30Record.from((SmfRecord)record);
                if (r30.header().smf30wid().equals("TSO") || r30.identificationSection().length() <= 250 || r30.identificationSection().smf30Jclid1().isZeros()) continue;
                jobsByJclId.computeIfAbsent(r30.identificationSection().smf30Jclid1(), entry -> new ArrayList()).add(new JobDetail(r30));
            }
        }
        jobsByJclId.entrySet().stream().filter(jclIdEntry -> ((List)jclIdEntry.getValue()).size() > 1).filter(jclIdEntry -> ((List)jclIdEntry.getValue()).stream().map(job -> job.jobname).distinct().count() > 1L).forEach(jclIdEntry -> {
            System.out.format("%n%s%n", jclIdEntry.getKey());
            Map<String, List<JobDetail>> jobsByName = ((List)jclIdEntry.getValue()).stream().collect(Collectors.groupingBy(JobDetail::getJobname));
            jobsByName.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(jobNameEntry -> {
                System.out.format("    %s%n", jobNameEntry.getKey());
                ((List)jobNameEntry.getValue()).stream().sorted(Comparator.comparing(JobDetail::getTime)).forEachOrdered(job -> System.out.format("        %-4s %-24s %-8s%n", job.system, job.time, job.jobnumber));
            });
        });
        System.out.println("Done");
    }

    private static class JobDetail {
        String jobname;
        String jobnumber;
        String system;
        LocalDateTime time;

        JobDetail(Smf30Record r30) {
            this.jobname = r30.identificationSection().smf30jbn();
            this.jobnumber = r30.identificationSection().smf30jnm();
            this.system = r30.system();
            this.time = r30.smfDateTime();
        }

        String getJobname() {
            return this.jobname;
        }

        LocalDateTime getTime() {
            return this.time;
        }
    }
}

