/*
 * Decompiled with CFR 0.152.
 */
package com.smfreports.type30;

import com.blackhillsoftware.smf.SmfRecord;
import com.blackhillsoftware.smf.SmfRecordReader;
import com.blackhillsoftware.smf.smf30.Smf30Record;
import java.io.IOException;

public class UserKeyCommon {
    public static void main(String[] args) throws IOException {
        if (args.length < 1) {
            System.out.println("Usage: UserKeyCommon <input-name>");
            System.out.println("<input-name> can be filename, //DD:DDNAME or //'DATASET.NAME'");
            return;
        }
        try (SmfRecordReader reader = SmfRecordReader.fromName((String)args[0]);){
            boolean foundAuditEnabled = false;
            int userKeyCommonFound = 0;
            for (SmfRecord record : reader.include(30)) {
                Smf30Record r30 = Smf30Record.from((SmfRecord)record);
                if (r30.storageSection() == null) continue;
                if (!foundAuditEnabled && r30.storageSection().smf30UserKeyCommonAuditEnabled()) {
                    foundAuditEnabled = true;
                }
                if (!r30.storageSection().smf30UserKeyCommonAuditEnabled() || !r30.storageSection().smf30UserKeyCsaUsage() && !r30.storageSection().smf30UserKeyCadsUsage() && !r30.storageSection().smf30UserKeyChangKeyUsage()) continue;
                ++userKeyCommonFound;
                System.out.format("%-23s %-4s %-8s %-8s %-10s %-10s %-10s%n", r30.smfDateTime(), r30.system(), r30.identificationSection().smf30jbn(), r30.identificationSection().smf30jnm(), r30.storageSection().smf30UserKeyCsaUsage() ? "CSA" : "", r30.storageSection().smf30UserKeyCadsUsage() ? "CADS" : "", r30.storageSection().smf30UserKeyChangKeyUsage() ? "KEYCHANGE" : "");
            }
            if (!foundAuditEnabled) {
                System.out.println("No records found with User Key Common Audit Enabled!");
            } else {
                System.out.format("%d records flagged", userKeyCommonFound);
            }
        }
    }
}

