/*
 * Decompiled with CFR 0.152.
 */
package com.smfreports.zedc;

import com.blackhillsoftware.smf.SmfRecord;
import com.blackhillsoftware.smf.SmfRecordReader;
import com.blackhillsoftware.smf.smf14.CompressedFormatDatasetSection;
import com.blackhillsoftware.smf.smf15.Smf15Record;
import java.io.IOException;
import java.util.Comparator;
import java.util.HashMap;

public class ZedcByDataset {
    public static void main(String[] args) throws IOException {
        if (args.length < 1) {
            System.out.println("Usage: ZedcByDataset <input-name>");
            System.out.println("<input-name> can be filename, //DD:DDNAME or //'DATASET.NAME'");
            return;
        }
        HashMap<String, DatasetInfo> datasets = new HashMap<String, DatasetInfo>();
        try (SmfRecordReader reader = SmfRecordReader.fromName((String)args[0]).include(15);){
            for (SmfRecord record : reader) {
                Smf15Record r15 = Smf15Record.from((SmfRecord)record);
                if (r15.compressedFormatDatasetSections().size() <= 0) continue;
                datasets.computeIfAbsent(r15.smfjfcb1().jfcbdsnm(), datasetName -> new DatasetInfo((String)datasetName)).add(r15);
            }
        }
        String headingFormat = "%-44s %8s %13s %13s %8s%n";
        String detailFormat = "%-44s %,8d %,13d %,13d %6.1f:1%n";
        System.out.format(headingFormat, "Dataset", "Count", "Uncomp MB", "Comp MB", "Ratio");
        datasets.entrySet().stream().map(entry -> (DatasetInfo)entry.getValue()).sorted(Comparator.comparing(DatasetInfo::getDatasetName)).forEachOrdered(dataset -> System.out.format(detailFormat, dataset.getDatasetName(), dataset.count, dataset.uncomp / 0x100000L, dataset.comp / 0x100000L, Float.valueOf(dataset.compRatio())));
        System.out.println("Done");
    }

    static class DatasetInfo {
        String datasetName;
        int count = 0;
        long comp = 0L;
        long uncomp = 0L;

        DatasetInfo(String datasetName) {
            this.datasetName = datasetName;
        }

        void add(Smf15Record r15) {
            ++this.count;
            this.comp += ((CompressedFormatDatasetSection)r15.compressedFormatDatasetSections().get(0)).smf14cds();
            this.uncomp += ((CompressedFormatDatasetSection)r15.compressedFormatDatasetSections().get(0)).smf14cdl();
        }

        String getDatasetName() {
            return this.datasetName;
        }

        float compRatio() {
            if (this.comp == 0L) {
                return 0.0f;
            }
            return (float)this.uncomp / (float)this.comp;
        }
    }
}

