/*
 * Decompiled with CFR 0.152.
 */
package com.smfreports.zedc;

import com.blackhillsoftware.smf.SmfRecord;
import com.blackhillsoftware.smf.SmfRecordReader;
import com.blackhillsoftware.smf.smf30.Smf30Record;
import com.blackhillsoftware.smf.smf30.ZEdcUsageStatisticsSection;
import java.io.IOException;
import java.util.Comparator;
import java.util.HashMap;

public class ZedcByJob {
    public static void main(String[] args) throws IOException {
        if (args.length < 1) {
            System.out.println("Usage: ZedcByJob <input-name>");
            System.out.println("<input-name> can be filename, //DD:DDNAME or //'DATASET.NAME'");
            return;
        }
        HashMap<String, JobInfo> jobs = new HashMap<String, JobInfo>();
        try (SmfRecordReader reader = SmfRecordReader.fromName((String)args[0]).include(30, 5);){
            for (SmfRecord record : reader) {
                Smf30Record r30 = Smf30Record.from((SmfRecord)record);
                if (r30.zEdcUsageStatisticsSections().isEmpty()) continue;
                jobs.computeIfAbsent(r30.identificationSection().smf30jbn(), jobname -> new JobInfo((String)jobname)).add(r30);
            }
        }
        String headingFormat = "%-8s %8s %13s %13s %8s %13s %13s %8s%n";
        String detailFormat = "%-8s %,8d %,13d %,13d %6.1f:1 %,13d %,13d %6.1f:1%n";
        System.out.format(headingFormat, "Jobname", "Count", "RD Comp MB", "Uncomp MB", "Ratio", "WR Uncomp MB", "Comp MB", "Ratio");
        jobs.entrySet().stream().map(entry -> (JobInfo)entry.getValue()).sorted(Comparator.comparing(JobInfo::getJobname)).forEachOrdered(jobname -> System.out.format(detailFormat, jobname.getJobname(), jobname.count, jobname.compRead / 0x100000L, jobname.uncompRead / 0x100000L, Float.valueOf(jobname.readCompRatio()), jobname.uncompWrite / 0x100000L, jobname.compWrite / 0x100000L, Float.valueOf(jobname.writeCompRatio())));
        System.out.println("Done");
    }

    static class JobInfo {
        String jobname;
        int count = 0;
        long compRead = 0L;
        long uncompRead = 0L;
        long compWrite = 0L;
        long uncompWrite = 0L;

        JobInfo(String jobName) {
            this.jobname = jobName;
        }

        void add(Smf30Record r30) {
            ++this.count;
            ZEdcUsageStatisticsSection zedc = (ZEdcUsageStatisticsSection)r30.zEdcUsageStatisticsSections().get(0);
            this.compRead += zedc.smf30UsInfComprIn();
            this.uncompRead += zedc.smf30UsInfDecomprOut();
            this.uncompWrite += zedc.smf30UsDefUncomprIn();
            this.compWrite += zedc.smf30UsDefComprOut();
        }

        float readCompRatio() {
            if (this.compRead == 0L) {
                return 0.0f;
            }
            return (float)this.uncompRead / (float)this.compRead;
        }

        float writeCompRatio() {
            if (this.compWrite == 0L) {
                return 0.0f;
            }
            return (float)this.uncompWrite / (float)this.compWrite;
        }

        String getJobname() {
            return this.jobname;
        }
    }
}

