/*
 * Decompiled with CFR 0.152.
 */
import com.blackhillsoftware.smf.SmfRecord;
import com.blackhillsoftware.smf.SmfRecordReader;
import com.blackhillsoftware.smf.Utils;
import com.blackhillsoftware.smf.cics.Smf110Record;
import com.blackhillsoftware.smf.cics.monitoring.PerformanceRecord;
import com.blackhillsoftware.smf.cics.monitoring.fields.Field;
import java.io.IOException;
import java.time.Duration;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class CicsTransactionResponse {
    public static void main(String[] args) throws IOException {
        if (args.length < 2) {
            System.out.println("Usage: CicsTransactionResponse <dictionary-name> <input-name> <input-name2> ...");
            System.out.println("<dictionary-name> CICS dictionaries, can be filename, //DD:DDNAME or //'DATASET.NAME'");
            System.out.println("<input-name> can be filename, //DD:DDNAME or //'DATASET.NAME'");
            return;
        }
        Smf110Record.dictionariesFromName(args[0]);
        HashMap<ApplidTran, TransactionData> data = new HashMap<ApplidTran, TransactionData>();
        int noDictionary = 0;
        int txCount = 0;
        for (int i = 1; i < args.length; ++i) {
            String name = args[i];
            try (SmfRecordReader reader = SmfRecordReader.fromName(name).include(110, 1);){
                for (SmfRecord smfrecord : reader) {
                    Smf110Record r110 = Smf110Record.from(smfrecord);
                    if (r110.haveDictionary()) {
                        String applid = r110.mnProductSection().smfmnprn();
                        for (PerformanceRecord txData : r110.performanceRecords()) {
                            String txName = txData.getField(Field.TRAN);
                            ++txCount;
                            ApplidTran key = new ApplidTran(applid, txName);
                            data.computeIfAbsent(key, k -> new TransactionData()).add(txData);
                        }
                        continue;
                    }
                    ++noDictionary;
                }
                continue;
            }
        }
        CicsTransactionResponse.writeReport(data);
        System.out.format("%n%nTotal Transactions: %,d%n", txCount);
        if (noDictionary > 0) {
            System.out.format("%n%nSkipped %,d records because no applicable dictionary was found.", noDictionary);
        }
        if (Smf110Record.getCompressedByteCount() > 0L) {
            System.out.format("%n%nCompressed bytes %,d, decompressed bytes %,d, compression %.1f%%.%n", Smf110Record.getCompressedByteCount(), Smf110Record.getDecompressedByteCount(), (double)(Smf110Record.getDecompressedByteCount() - Smf110Record.getCompressedByteCount()) / (double)Smf110Record.getDecompressedByteCount() * 100.0);
        }
    }

    private static void writeReport(Map<ApplidTran, TransactionData> data) {
        data.entrySet().stream().collect(Collectors.groupingBy(e -> ((ApplidTran)e.getKey()).applid())).entrySet().stream().sorted(Map.Entry.comparingByKey()).forEachOrdered(applidSection -> {
            System.out.format("%n%-10s %-4s %15s %15s %15s %15s %15s %15s %15s%n", "APPLID", "Tran", "Count", "CPU", "Avg CPU", "Avg Elapsed", "Avg Term Waits", "Avg Term Wait", "Avg Response");
            ((List)applidSection.getValue()).stream().sorted(Comparator.comparing(e -> ((ApplidTran)e.getKey()).tran())).forEachOrdered(e -> {
                TransactionData tx = (TransactionData)e.getValue();
                System.out.format("%-10s %-4s %15d %15f %15f %15f %15.1f %15f %15f%n", ((ApplidTran)e.getKey()).applid(), ((ApplidTran)e.getKey()).tran(), tx.getCount(), tx.getSumCpu(), tx.getAvgCpu(), tx.getAvgElapsed(), tx.getAvgTciowttCount(), tx.getAvgTciowttTime(), tx.getAvgResponse());
            });
            System.out.println();
        });
    }

    private record ApplidTran(String applid, String tran) {
    }

    private static class TransactionData {
        private int count = 0;
        private double elapsed = 0.0;
        private double cpu = 0.0;
        private long tciowttCount = 0L;
        private double tciowttTime = 0.0;

        private TransactionData() {
        }

        public void add(PerformanceRecord txData) {
            ++this.count;
            this.elapsed += Utils.ToSeconds(Duration.between(txData.getField(Field.START), txData.getField(Field.STOP)));
            this.cpu += txData.getField(Field.USRCPUT).timerSeconds();
            this.tciowttCount += (long)txData.getField(Field.TCIOWTT).count();
            this.tciowttTime += txData.getField(Field.TCIOWTT).timerSeconds();
        }

        public int getCount() {
            return this.count;
        }

        public double getSumCpu() {
            return this.cpu;
        }

        public Double getAvgCpu() {
            return this.count != 0 ? Double.valueOf(this.cpu / (double)this.count) : null;
        }

        public Double getAvgElapsed() {
            return this.count != 0 ? Double.valueOf(this.elapsed / (double)this.count) : null;
        }

        public Double getAvgTciowttCount() {
            return this.count != 0 ? Double.valueOf((double)this.tciowttCount / (double)this.count) : null;
        }

        public Double getAvgTciowttTime() {
            return this.count != 0 ? Double.valueOf(this.tciowttTime / (double)this.count) : null;
        }

        public double getAvgResponse() {
            long responseCount = (long)this.count + this.tciowttCount;
            return responseCount != 0L ? (this.elapsed - this.tciowttTime) / (double)responseCount : 0.0;
        }
    }
}

