/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.zutil.io;

import com.blackhillsoftware.zutil.io.RecordWriter;
import com.ibm.jzos.fields.StringField;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Objects;

public class TextRecordWriter
extends RecordWriter
implements Closeable {
    private byte[] buff;
    private StringField stringField;
    private boolean wrapLines = false;
    private boolean recfmv = false;
    private int maxLine;

    TextRecordWriter(com.ibm.jzos.RecordWriter recordWriter) {
        super(recordWriter);
        this.recfmv = (recordWriter.getRecfmBits() & 2) == 2;
        this.maxLine = this.recfmv ? recordWriter.getLrecl() - 4 : recordWriter.getLrecl();
        this.buff = new byte[this.maxLine];
        this.stringField = new StringField(0, this.maxLine, false, false, false);
    }

    public static TextRecordWriter newWriter(String name, int flags) throws IOException {
        return new TextRecordWriter(com.ibm.jzos.RecordWriter.newWriter((String)name, (int)flags));
    }

    public static TextRecordWriter newWriterForDD(String ddname) throws IOException {
        return new TextRecordWriter(com.ibm.jzos.RecordWriter.newWriterForDD((String)ddname));
    }

    public TextRecordWriter setEncoding(String encoding) {
        this.stringField.setEncoding(encoding);
        return this;
    }

    public String getEncoding() {
        return this.stringField.getEncoding();
    }

    public void writeLine(String out) throws IOException {
        String[] lines;
        Objects.requireNonNull(out);
        for (String line : lines = out.split("\\R", -1)) {
            ArrayList<String> wrappedLines = new ArrayList<String>();
            if (this.wrapLines && line.length() > this.maxLine) {
                int thisLength;
                for (int offset = 0; offset < line.length(); offset += thisLength) {
                    thisLength = Math.min(this.maxLine, line.length() - offset);
                    wrappedLines.add(line.substring(offset, offset + thisLength));
                }
            } else {
                wrappedLines.add(line);
            }
            for (String outputLine : wrappedLines) {
                if (outputLine.length() > this.maxLine) {
                    throw new IllegalArgumentException(String.format("Line length %d is greater than maximum length %d for %s LRECL %d", outputLine.length(), this.maxLine, this.getRecfm(), this.getLrecl()));
                }
                this.stringField.putString(outputLine, this.buff);
                super.write(this.buff, 0, this.recfmv ? outputLine.length() : this.buff.length);
            }
        }
    }

    public TextRecordWriter setWrapLines(boolean wrapLines) {
        this.wrapLines = wrapLines;
        return this;
    }

    public boolean getWrapLines() {
        return this.wrapLines;
    }

    @Override
    public void write(byte[] buf) {
        throw new UnsupportedOperationException("TextRecordWriter does not support writing from byte arrays");
    }

    @Override
    public void write(byte[] buf, int offset, int len) {
        throw new UnsupportedOperationException("TextRecordWriter does not support writing from byte arrays");
    }
}

