/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.zutil.io;

import com.blackhillsoftware.zutil.io.RecordReader;
import com.ibm.jzos.fields.StringField;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class TextRecordReader
extends RecordReader
implements Closeable {
    byte[] buff;
    StringField stringField;

    TextRecordReader(com.ibm.jzos.RecordReader recordReader) {
        super(recordReader);
        this.buff = new byte[recordReader.getLrecl()];
        this.stringField = new StringField(0, recordReader.getLrecl(), false, false, false);
    }

    public static TextRecordReader newReader(String name, int flags) throws IOException {
        return new TextRecordReader(com.ibm.jzos.RecordReader.newReader((String)name, (int)flags));
    }

    public static TextRecordReader newReaderForDD(String ddname) throws IOException {
        return new TextRecordReader(com.ibm.jzos.RecordReader.newReaderForDD((String)ddname));
    }

    public TextRecordReader setEncoding(String encoding) {
        this.stringField.setEncoding(encoding);
        return this;
    }

    public String getEncoding() {
        return this.stringField.getEncoding();
    }

    public String readLine() throws IOException {
        int length = super.read(this.buff);
        if (length < 0) {
            return null;
        }
        this.stringField.setByteLength(length);
        return this.stringField.getString(this.buff);
    }

    public List<String> readAllLines() throws IOException {
        ArrayList<String> result = new ArrayList<String>();
        String record = this.readLine();
        while (record != null) {
            result.add(record);
            record = this.readLine();
        }
        return result;
    }

    @Override
    public int read(byte[] buf) {
        throw new UnsupportedOperationException("TextRecordReader does not support reading to byte arrays");
    }

    @Override
    public int read(byte[] buf, int offset, int len) {
        throw new UnsupportedOperationException("TextRecordReader does not support reading to byte arrays");
    }
}

