/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.realtime;

import com.blackhillsoftware.smf.realtime.InMemoryResource;
import com.blackhillsoftware.smf.realtime.SmfConnection;
import java.io.IOException;
import java.util.List;

public class Query {
    public static void main(String[] args) throws IOException {
        Query.printResources();
    }

    static void printResources() throws IOException {
        List<InMemoryResource> result = SmfConnection.query();
        System.out.format("%d SMF in memory resource(s) found.%n", result.size());
        for (InMemoryResource entry : result) {
            Integer startRange = null;
            Integer endRange = null;
            System.out.format("%n%s%n", entry.name());
            if (entry.isSimulated()) {
                System.out.format("  Simulated Filename: %s%n", entry.file());
                continue;
            }
            System.out.format("Record Types:%n", new Object[0]);
            for (Integer smftype : entry.getSmfTypes()) {
                if (startRange == null) {
                    startRange = smftype;
                    endRange = smftype;
                    continue;
                }
                if (smftype == endRange + 1) {
                    endRange = smftype;
                    continue;
                }
                Query.printRange(startRange, endRange);
                startRange = smftype;
                endRange = smftype;
            }
            Query.printRange(startRange, endRange);
        }
    }

    private static void printRange(Integer startRange, Integer endRange) {
        if (startRange == null) {
            return;
        }
        if (startRange.equals(endRange) || endRange == null) {
            System.out.println("    " + startRange);
        } else {
            System.out.println("    " + startRange + ":" + endRange);
        }
    }
}

