/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.realtime;

import com.blackhillsoftware.smf.realtime.InMemoryResource;
import com.blackhillsoftware.smf.realtime.MissedDataEvent;
import com.blackhillsoftware.smf.realtime.MissedDataException;
import com.blackhillsoftware.smf.realtime.RcReason;
import com.blackhillsoftware.smf.realtime.SmfConnection;
import com.blackhillsoftware.zutil.mvs.CommandHandler;
import com.ibm.jzos.MvsConsole;
import com.ibm.jzos.fields.AssemblerDatatypeFactory;
import com.ibm.jzos.fields.StringField;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Queue;

class SmfRtiConnection
extends SmfConnection {
    private ByteBuffer smfRtiBuf;
    private volatile boolean isConnected = false;
    private Object getLock = new Object();

    SmfRtiConnection(String name) {
        super(name);
    }

    private void doConnect(byte[] namebytes, int nameLength, ByteBuffer buf) throws IOException, RcReason {
        Objects.requireNonNull(buf, "Buffer is null");
        Objects.requireNonNull(namebytes, "Name buffer is null");
        if (nameLength > namebytes.length) {
            throw new IllegalArgumentException("Name length is invalid");
        }
        SmfRtiConnection.connect(buf, nameLength, namebytes);
    }

    private void doDisconnect(ByteBuffer buf) throws IOException, RcReason {
        Objects.requireNonNull(buf, "Buffer is null");
        SmfRtiConnection.disconnect(buf);
    }

    private void doGet(ByteBuffer buf) throws IOException, RcReason {
        Objects.requireNonNull(buf, "Buffer is null");
        SmfRtiConnection.getRecords(buf);
    }

    private static int doListResources(byte[] output) throws IOException, RcReason {
        Objects.requireNonNull(output, "Buffer is null");
        int count = SmfRtiConnection.listResources(output.length, output);
        return count;
    }

    static List<InMemoryResource> doQuery() throws IOException {
        byte[] output = new byte[9216];
        try {
            int count = SmfRtiConnection.doListResources(output);
            ArrayList<InMemoryResource> entries = new ArrayList<InMemoryResource>();
            for (int i = 0; i < count; ++i) {
                entries.add(InMemoryResource.create(output, i * 288, 288));
            }
            return entries;
        }
        catch (RcReason rc) {
            throw new IOException(rc);
        }
    }

    @Override
    synchronized SmfConnection connect() throws IOException {
        AssemblerDatatypeFactory datatypes = new AssemblerDatatypeFactory();
        datatypes.setOffset(0);
        StringField nameField = datatypes.getStringField(26);
        byte[] namebytes = new byte[26];
        nameField.putString(this.getResourceName(), namebytes);
        this.smfRtiBuf = ByteBuffer.allocateDirect(0x8000000);
        try {
            this.doConnect(namebytes, this.getResourceName().length(), this.smfRtiBuf);
            this.isConnected = true;
        }
        catch (RcReason rc) {
            throw new IOException(rc);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void readRecords(Queue<byte[]> inner) throws IOException, MissedDataException {
        Object object = this.getLock;
        synchronized (object) {
            ByteBuffer myBuf = this.smfRtiBuf;
            if (this.isConnected) {
                try {
                    this.doGet(myBuf);
                    SmfRtiConnection.extractRecords(myBuf, inner);
                }
                catch (RcReason rc) {
                    SmfRtiConnection.extractRecords(myBuf, inner);
                    switch (rc.getReason()) {
                        case 1025: {
                            MissedDataEvent missed = new MissedDataEvent(this);
                            if (this.onMissedData != null) {
                                this.onMissedData.accept(missed);
                            }
                            if (!missed.getThrowException()) break;
                            throw new MissedDataException();
                        }
                        case 1030: 
                        case 1032: {
                            break;
                        }
                        case 2052: {
                            if (!this.isConnected) break;
                            throw new IOException(rc);
                        }
                        default: {
                            throw new IOException(rc);
                        }
                    }
                }
            }
        }
    }

    private static void extractRecords(ByteBuffer buf, Queue<byte[]> inner) throws IOException {
        short reclen;
        buf.position(52);
        int bytes = buf.getInt();
        buf.position(64);
        for (int processed = 0; bytes > processed; processed += reclen) {
            buf.mark();
            reclen = buf.getShort();
            if (reclen < 4) {
                throw new IOException("Bad record length: " + Integer.toString(reclen));
            }
            buf.reset();
            byte[] record = new byte[reclen];
            buf.get(record);
            inner.add(record);
        }
    }

    @Override
    protected boolean handleStop() {
        try {
            this.close();
        }
        catch (IOException e) {
            MvsConsole.wto((String)("IOException ocurred closing connection: " + e.toString()), (int)32, (int)16);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public synchronized void close() throws IOException {
        try {
            int attempts = 0;
            while (this.isConnected) {
                ++attempts;
                try {
                    this.doDisconnect(this.smfRtiBuf);
                    this.isConnected = false;
                }
                catch (RcReason rc) {
                    if (rc.getRc() != 4 || rc.getReason() != 1029 || attempts >= 5) throw new IOException(rc);
                    try {
                        Thread.sleep(1000L);
                        continue;
                    }
                    catch (InterruptedException e) {
                        throw new IOException("Close Interrupted" + System.lineSeparator() + e.toString() + System.lineSeparator() + rc.getMessage());
                    }
                    return;
                }
            }
        }
        finally {
            this.isConnected = false;
            this.smfRtiBuf = null;
            this.onMissedData = null;
            if (this.stopHandler != null) {
                CommandHandler.removeStop((CommandHandler)this.stopHandler);
            }
        }
    }

    static {
        String libName = "easysmf-rti";
        try {
            String expectedOS = "z/OS";
            String osName = System.getProperty("os.name");
            if (!expectedOS.equals(osName)) {
                slf4jLogger.warn("Attempting to load JNI functions, expected operating system {} but Java reports {}.", (Object)expectedOS, (Object)osName);
                slf4jLogger.warn("Set environment variable {}=YES to run in simulated mode.", (Object)"SIMULATE_RTI");
            }
            File tmpDir = Files.createTempDirectory("EasySMF-RTI", PosixFilePermissions.asFileAttribute(PosixFilePermissions.fromString("rwx------"))).toFile();
            tmpDir.deleteOnExit();
            File nativeLibTmpFile = Files.createTempFile(tmpDir.toPath(), libName, ".so", new FileAttribute[0]).toFile();
            nativeLibTmpFile.deleteOnExit();
            try (InputStream in = SmfRtiConnection.class.getResourceAsStream("/" + libName + ".so");){
                if (in == null) {
                    throw new RuntimeException("Could not find resource for JNI dll in jar");
                }
                Files.copy(in, nativeLibTmpFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            Files.setPosixFilePermissions(nativeLibTmpFile.toPath(), PosixFilePermissions.fromString("rwx------"));
            System.load(nativeLibTmpFile.getAbsolutePath());
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }
}

