## Basic Usage ##

These samples demonstrate the basic usage of the EasySMF-JSON functions.

### Smf30JsonJobList ###

- [Source](Smf30JsonJobList.java)

This sample creates JSON for selected data from SMF 30 Job End records.

It shows how to create a class to extract specific fields and record sections from the SMF record to be included in the JSON output.

### Smf30RecordToJson ###

- [Source](Smf30RecordToJson.java)

This sample demonstrates formatting a single record using the JSON pretty print format. It is useful if you want to see the format of the data in a particular SMF record, because the structure of the sections is visible and you can see relationships between them.

The sample formats a SMF 30 Step End record for an IEFBR14 step, to keep the amount of output data to manageable quantities.

#### Smf30RecordToJson Output ####

```
{
  "extendedHeader": false,
  "hasSubtypes": true,
  "recordLength": 1282,
  "recordType": 30,
  "smfDate": "2022-01-05",
  "smfDateTime": "2022-01-05T16:54:10.57",
  "smfTime": "16:54:10.57",
  "subSystem": "JES2",
  "subType": 4,
  "system": "S0W1",
  "completionSection": {
    "completionDescription": "0",
    "smf30abd": false,
    "smf30arc": 0,
    "smf30cde": false,
    "smf30cnr": false,
    "smf30ere": false,
    "smf30exf": false,
    "smf30flh": false,
    "smf30isk": false,
    "smf30nex": false,
    "smf30scc": 0,
    "smf30slc": false,
    "smf30srs": false,
    "smf30sti": 0,
    "smf30stiByte1": 0,
    "smf30stiByte2": 0,
    "smf30sye": false,
    "smf30trt": false,
    "smf30uab": false,
    "smf30uji": false,
    "smf30ujv": false,
    "smf30usi": false
  },
  "excpSections": [
    {
      "smf30blk": 0,
      "smf30bsz": 0,
      "smf30cua": 3297,
      "smf30dctSeconds": 0.0,
      "smf30ddn": "DEL",
      "smf30dev": 32,
      "smf30utp": 15,
      "smf30xbs": 0
    }
  ],
  "header": {
    "smf30aln": 0,
    "smf30aof": 1252,
    "smf30aon": 0,
    "smf30arl": 40,
    "smf30arn": 0,
    "smf30aro": 1252,
    "smf30cdl": 96,
    "smf30cdn": 0,
    "smf30cdo": 1252,
    "smf30cln": 192,
    "smf30cof": 564,
    "smf30con": 1,
    "smf30drl": 40,
    "smf30drn": 0,
    "smf30dro": 1292,
    "smf30dte": "2022-01-05",
    "smf30eln": 30,
    "smf30eof": 1252,
    "smf30eon": 1,
    "smf30eor": 0,
    "smf30eos": 0,
    "smf30flg": 222,
    "smf30iln": 250,
    "smf30iof": 230,
    "smf30ion": 1,
    "smf30len": 1282,
    "smf30mln": 20,
    "smf30mno": 0,
    "smf30mof": 0,
    "smf30mos": 0,
    "smf30oln": 24,
    "smf30oof": 1228,
    "smf30oon": 1,
    "smf30opl": 96,
    "smf30opm": 0,
    "smf30opn": 0,
    "smf30opo": 0,
    "smf30pln": 216,
    "smf30pof": 1012,
    "smf30pon": 1,
    "smf30rln": 256,
    "smf30rml": 80,
    "smf30rmn": 0,
    "smf30rmo": 0,
    "smf30rms": 0,
    "smf30rof": 756,
    "smf30ron": 1,
    "smf30rty": 30,
    "smf30rvd": 0,
    "smf30seg": 0,
    "smf30sid": "S0W1",
    "smf30sln": 38,
    "smf30sof": 192,
    "smf30son": 1,
    "smf30stp": 4,
    "smf30tln": 8,
    "smf30tme": "16:54:10.57",
    "smf30tof": 556,
    "smf30ton": 1,
    "smf30udl": 76,
    "smf30udn": 0,
    "smf30udo": 0,
    "smf30uds": 0,
    "smf30uln": 76,
    "smf30uof": 480,
    "smf30uon": 1,
    "smf30usl": 64,
    "smf30usn": 0,
    "smf30uso": 1252,
    "smf30wid": "JES2"
  },
  "identificationSection": {
    "smf30asi": 51,
    "smf30ast": "16:54:09.92",
    "smf30cl8": "A",
    "smf30cls": "A",
    "smf30cor": "J0009139SVSCJES2DADDFAA9.......:",
    "smf30exn": "",
    "smf30grp": "GROUP1",
    "smf30iet": "2022-01-05T05:54:10.573224285Z",
    "smf30iss": "2022-01-05T05:54:09.908285411Z",
    "smf30jbn": "ANDREWRB",
    "smf30jf1": 0,
    "smf30jnm": "JOB09139",
    "smf30jpt": 0,
    "smf30pgf": false,
    "smf30pgm": "IEFBR14",
    "smf30pgn": 0,
    "smf30pps": "16:54:10.31",
    "smf30psn": "",
    "smf30red": "2022-01-05",
    "smf30ret": "16:54:09.1",
    "smf30rsd": "2022-01-05",
    "smf30rst": "16:54:08.8",
    "smf30rud": "ANDREWR",
    "smf30sit": "16:54:09.9",
    "smf30ssn": 0,
    "smf30std": "2022-01-05",
    "smf30stm": "DELETE",
    "smf30stn": 1,
    "smf30tid": "",
    "smf30tsn": "",
    "smf30uif": "",
    "smf30usr": ""
  },
  "ioActivitySection": {
    "smf30aicSeconds": 0.014976,
    "smf30aidSeconds": 0.0,
    "smf30ais": 15,
    "smf30aiwSeconds": 0.0,
    "smf30das": 0,
    "smf30dcf": 0,
    "smf30eicSeconds": 0.0,
    "smf30eidSeconds": 0.0,
    "smf30eis": 0,
    "smf30eiwSeconds": 0.0,
    "smf30iin": false,
    "smf30inp": 0,
    "smf30mfl": false,
    "smf30rdr": " ",
    "smf30rdt": " ",
    "smf30rs2": "",
    "smf30rsb": 0,
    "smf30tcnSeconds": 0.001024,
    "smf30tef": false,
    "smf30tep": 4,
    "smf30tex": 4,
    "smf30tgt": 0,
    "smf30tpt": 0,
    "smf30trr": 0
  },
  "operatorSection": {
    "smf30msr": 0,
    "smf30mtm": 0,
    "smf30pdm": 0,
    "smf30prd": 0,
    "smf30ptm": 0,
    "smf30tpr": 0
  },
  "performanceSection": {
    "smf30CapacityAdjustmentInd": 100,
    "smf30CapacityChangeCnt": 0,
    "smf30CapacityChangeRsn": 0,
    "smf30CapacityDataErr": false,
    "smf30CapacityFlags": 0,
    "smf30EventDrivenIntvlRec": false,
    "smf30PcdRsvdExists": false,
    "smf30RctpcpuaActual": 31296,
    "smf30RctpcpuaNominal": 31296,
    "smf30RctpcpuaScalingFactor": 64,
    "smf30RmctadjnNominal": 170,
    "smf30RqsvsusErr": false,
    "smf30acb": 0,
    "smf30asp": false,
    "smf30ccp": false,
    "smf30cpc": 10,
    "smf30cpr": false,
    "smf30cr": 0,
    "smf30crm": false,
    "smf30csp": false,
    "smf30csu": 48,
    "smf30csuInv": false,
    "smf30csuL": 48,
    "smf30esu": 0,
    "smf30esuInv": false,
    "smf30esuL": 0,
    "smf30etaSeconds": 0.0,
    "smf30etc": 0,
    "smf30grn": "",
    "smf30hqtSeconds": 0.0,
    "smf30inv": 0,
    "smf30io": 0,
    "smf30ioInv": false,
    "smf30ioL": 0,
    "smf30jpn": "SVSCJES2",
    "smf30jqtSeconds": 1.048576,
    "smf30lga": false,
    "smf30loc": 1,
    "smf30msc": 1,
    "smf30msi": false,
    "smf30mso": 0,
    "smf30msoInv": false,
    "smf30msoL": 0,
    "smf30p1a": false,
    "smf30pf1": 0,
    "smf30pf2": 0,
    "smf30pff": false,
    "smf30pfj": false,
    "smf30pfl": "",
    "smf30pfr": false,
    "smf30pin": false,
    "smf30rcn": "",
    "smf30resSeconds": 0.0,
    "smf30rqtSeconds": 0.0,
    "smf30rs5": " ",
    "smf30rs6": "",
    "smf30rtr": false,
    "smf30scn": "BATMDM",
    "smf30sme": false,
    "smf30snf": 256,
    "smf30spr": false,
    "smf30sqtSeconds": 1.150976,
    "smf30srb": 0,
    "smf30srbInv": false,
    "smf30srbL": 0,
    "smf30src": 10,
    "smf30srv": 48,
    "smf30srvInv": false,
    "smf30srvL": 48,
    "smf30sus": 170,
    "smf30tatSeconds": 0.0,
    "smf30trs": 0,
    "smf30wlm": "BATCH",
    "smf30wmi": false,
    "smf30zep": 0,
    "smf30znf": 256
  },
  "processorAccountingSection": {
    "smf30Bi": 0,
    "smf30BoostClassIpl": false,
    "smf30BoostClassRp": false,
    "smf30BoostClassShutdown": false,
    "smf30BoostInfo": 0,
    "smf30CepiF": false,
    "smf30DepEnclaveTimeIfaOnCpF": false,
    "smf30DepEnclaveTimeIfaOnCpSeconds": 0.0,
    "smf30DepEnclaveTimeOnIfaF": false,
    "smf30DepEnclaveTimeOnIfaSeconds": 0.0,
    "smf30DepEnclaveTimeOnZcbpF": false,
    "smf30DepEnclaveTimeOnZcbpSeconds": 0.0,
    "smf30DepEnclaveTimeZcbpOnCpF": false,
    "smf30DepEnclaveTimeZcbpOnCpSeconds": 0.0,
    "smf30DepencTimeOnSupF": false,
    "smf30DepencTimeOnSupNF": false,
    "smf30DepencTimeOnSupSeconds": 0.0,
    "smf30DepencTimeOnZiipF": false,
    "smf30DepencTimeOnZiipNF": false,
    "smf30DepencTimeOnZiipSeconds": 0.0,
    "smf30DepencTimeSupOnCpF": false,
    "smf30DepencTimeSupOnCpSeconds": 0.0,
    "smf30DepencTimeSupQualF": false,
    "smf30DepencTimeSupQualSeconds": 0.0,
    "smf30DepencTimeZiipOnCpF": false,
    "smf30DepencTimeZiipOnCpSeconds": 0.0,
    "smf30DepencTimeZiipQualF": false,
    "smf30DepencTimeZiipQualSeconds": 0.0,
    "smf30EnclaveTimeIfaOnCpF": false,
    "smf30EnclaveTimeIfaOnCpSeconds": 0.0,
    "smf30EnclaveTimeOnIfaF": false,
    "smf30EnclaveTimeOnIfaSeconds": 0.0,
    "smf30EnclaveTimeOnSupF": false,
    "smf30EnclaveTimeOnSupNF": false,
    "smf30EnclaveTimeOnSupSeconds": 0.0,
    "smf30EnclaveTimeOnZcbpF": false,
    "smf30EnclaveTimeOnZcbpSeconds": 0.0,
    "smf30EnclaveTimeOnZiipF": false,
    "smf30EnclaveTimeOnZiipNF": false,
    "smf30EnclaveTimeOnZiipSeconds": 0.0,
    "smf30EnclaveTimeSupOnCpF": false,
    "smf30EnclaveTimeSupOnCpSeconds": 0.0,
    "smf30EnclaveTimeSupQualF": false,
    "smf30EnclaveTimeSupQualSeconds": 0.0,
    "smf30EnclaveTimeZcbpOnCpF": false,
    "smf30EnclaveTimeZcbpOnCpSeconds": 0.0,
    "smf30EnclaveTimeZiipOnCpF": false,
    "smf30EnclaveTimeZiipOnCpSeconds": 0.0,
    "smf30EnclaveTimeZiipQualF": false,
    "smf30EnclaveTimeZiipQualSeconds": 0.0,
    "smf30HighestTaskCpuPercent": 0,
    "smf30HighestTaskCpuProgram": "IEFIIC",
    "smf30MissedSmf30blk": 0,
    "smf30MissedSmf30dct": 0,
    "smf30SpeedBoostActive": false,
    "smf30TimeIfaOnCpF": false,
    "smf30TimeIfaOnCpSeconds": 0.0,
    "smf30TimeOnIfaF": false,
    "smf30TimeOnIfaSeconds": 0.0,
    "smf30TimeOnSupF": false,
    "smf30TimeOnSupSeconds": 0.0,
    "smf30TimeOnZcbpF": false,
    "smf30TimeOnZcbpSeconds": 0.0,
    "smf30TimeOnZiipF": false,
    "smf30TimeOnZiipSeconds": 0.0,
    "smf30TimeSupOnCpF": false,
    "smf30TimeSupOnCpSeconds": 0.0,
    "smf30TimeZcbpOnCpF": false,
    "smf30TimeZcbpOnCpSeconds": 0.0,
    "smf30TimeZiipOnCpF": false,
    "smf30TimeZiipOnCpSeconds": 0.0,
    "smf30asf": false,
    "smf30asrSeconds": 0.0,
    "smf30casFlag": 0,
    "smf30casInEligHonorPriority": false,
    "smf30casInelighonorpriority": false,
    "smf30casOa54589": [
      "00000000 : 00000000"
    ],
    "smf30cepSeconds": 0.0,
    "smf30cepiSeconds": 0.0,
    "smf30cin": false,
    "smf30cpsSeconds": 0.0,
    "smf30cptSeconds": 0.0,
    "smf30crpF": false,
    "smf30crpSeconds": 0.0,
    "smf30csc": 0,
    "smf30csf": false,
    "smf30ctf": false,
    "smf30def": false,
    "smf30detSeconds": 0.0,
    "smf30dmi": 0,
    "smf30dmo": 0,
    "smf30encSeconds": 0.0,
    "smf30enf": false,
    "smf30hpf": false,
    "smf30hptSeconds": 0.0,
    "smf30iaf": false,
    "smf30icf": false,
    "smf30icuSeconds": 0.01,
    "smf30icuStepInitSeconds": 0.01,
    "smf30icuStepTermSeconds": 0.0,
    "smf30idt": "1899-12-31",
    "smf30iif": false,
    "smf30iipSeconds": 0.0,
    "smf30isbSeconds": 0.0,
    "smf30isbStepInitSeconds": 0.0,
    "smf30isbStepTermSeconds": 0.0,
    "smf30isf": false,
    "smf30ist": "00:00:00",
    "smf30ivaSeconds": 0.0,
    "smf30ivf": false,
    "smf30ivuSeconds": 0.0,
    "smf30jvaSeconds": 0.0,
    "smf30jvuSeconds": 0.0,
    "smf30pty": 0,
    "smf30rcf": false,
    "smf30rctSeconds": 0.0,
    "smf30rv3": 32768,
    "smf30t32": 0,
    "smf30t33": 0,
    "smf30tf2": 0,
    "smf30tfl": 32768,
    "smf30tflByte1": 128,
    "smf30tflByte2": 0,
    "smf30tfo": true,
    "smf30vaf": false,
    "smf30vuf": false,
    "smf30ziipBoostActive": false
  },
  "storageSection": {
    "smf30NumberOfDataSpacesHWM": 0,
    "smf30RUCSAEarlyUsage": false,
    "smf30RaxFlags": 128,
    "smf30Raxflags": 128,
    "smf30RsvdHBB77B0Exists": false,
    "smf30UserDataSpaceCreateReqCount": 0,
    "smf30UserKeyCadsUsage": false,
    "smf30UserKeyChangKeyUsage": false,
    "smf30UserKeyCommonAuditEnabled": true,
    "smf30UserKeyCsaUsage": false,
    "smf30UserKeyRuCsaUsage": false,
    "smf30Userkeyrucsausage": false,
    "smf30arb": 237568,
    "smf30bia": 0,
    "smf30bie": 0,
    "smf30boa": 0,
    "smf30boe": 0,
    "smf30cpi": 0,
    "smf30cpm": 0,
    "smf30dsv": 0,
    "smf30ear": 11341824,
    "smf30erg": 1695547392,
    "smf30ers": 0,
    "smf30eur": 0,
    "smf30hpi": 0,
    "smf30hpo": 0,
    "smf30hsh": 0,
    "smf30hso": 0,
    "smf30hva": 0,
    "smf30hvh": 12582912,
    "smf30hvo": 13631488,
    "smf30hvr": 8,
    "smf30kia": 0,
    "smf30kie": 0,
    "smf30koa": 0,
    "smf30koe": 0,
    "smf30lpi": 0,
    "smf30mem": 3072,
    "smf30mes": 1,
    "smf30nhu": false,
    "smf30nsw": 0,
    "smf30pai": 0,
    "smf30pei": 0,
    "smf30pgi": 0,
    "smf30pgo": 0,
    "smf30pia": 0,
    "smf30pie": 0,
    "smf30poa": 0,
    "smf30poe": 0,
    "smf30prv": 4,
    "smf30psc": 0,
    "smf30psf": 0,
    "smf30psi": 0,
    "smf30pso": 0,
    "smf30pst": 0,
    "smf30rgb": 8364032,
    "smf30rgn": 1024,
    "smf30rsv": 0,
    "smf30sfl": 0,
    "smf30sin": false,
    "smf30sl1": false,
    "smf30sl2": false,
    "smf30sl3": false,
    "smf30sl4": false,
    "smf30sl5": false,
    "smf30sl6": false,
    "smf30slm": 0,
    "smf30spk": 8,
    "smf30sys": 232,
    "smf30tih": 20,
    "smf30tis": 32736,
    "smf30tiu": 0,
    "smf30ucl": false,
    "smf30ucm": false,
    "smf30urb": 4096,
    "smf30vpi": 0,
    "smf30vpo": 0,
    "smf30vpr": 0,
    "smf30vqr": false
  },
  "subSystemSection": {
    "smf30Zcbp": false,
    "smf30osl": "SP7.2.4",
    "smf30pflags": 0,
    "smf30pnm": "SMF",
    "smf30rvn": "05",
    "smf30syn": "S0W1",
    "smf30syp": "SVSCPLEX",
    "smf30typ": 4
  }
}
```